/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.permanent.token.MonkeyToken;

class MonkeyCageEffect
extends OneShotEffect {
    MonkeyCageEffect() {
        super(Outcome.Benefit);
        this.staticText = "and create X 2/2 green Monkey creature tokens, where X is that creature's mana value";
    }

    private MonkeyCageEffect(MonkeyCageEffect effect) {
        super((OneShotEffect)effect);
    }

    public MonkeyCageEffect copy() {
        return new MonkeyCageEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent creature = this.getTargetPointer().getFirstTargetPermanentOrLKI(game, source);
        if (creature == null) {
            return false;
        }
        int cmc = creature.getManaValue();
        return cmc > 0 && new MonkeyToken().putOntoBattlefield(cmc, game, source);
    }
}

