/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import java.util.Optional;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.costs.Cost;
import mage.abilities.costs.CostImpl;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.filter.FilterCard;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Controllable;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetCard;
import mage.target.common.TargetCardInHand;
import mage.target.common.TargetControlledCreaturePermanent;

class MonstrousEmergenceCost
extends CostImpl {
    public MonstrousEmergenceCost() {
        this.text = "choose a creature you control or reveal a creature card from your hand";
    }

    private MonstrousEmergenceCost(MonstrousEmergenceCost cost) {
        super((CostImpl)cost);
    }

    public MonstrousEmergenceCost copy() {
        return new MonstrousEmergenceCost(this);
    }

    public boolean canPay(Ability ability, Ability source, UUID controllerId, Game game) {
        return Optional.ofNullable(source).map(Controllable::getControllerId).map(arg_0 -> ((Game)game).getPlayer(arg_0)).map(Player::getHand).filter(hand -> hand.count((FilterCard)StaticFilters.FILTER_CARD_CREATURE, game) > 0).isPresent() || game.getBattlefield().contains((FilterPermanent)StaticFilters.FILTER_CONTROLLED_CREATURE, controllerId, source, game, 1);
    }

    public boolean pay(Ability ability, Game game, Ability source, UUID controllerId, boolean noMana, Cost costToPay) {
        boolean usePermanent;
        boolean hasHand;
        Player player = game.getPlayer(controllerId);
        if (player == null) {
            this.paid = false;
            return this.paid;
        }
        boolean hasPermanent = game.getBattlefield().contains((FilterPermanent)StaticFilters.FILTER_CONTROLLED_CREATURE, controllerId, source, game, 1);
        boolean bl = hasHand = player.getHand().count((FilterCard)StaticFilters.FILTER_CARD_CREATURE, game) > 0;
        if (hasPermanent && hasHand) {
            usePermanent = player.chooseUse(Outcome.Neutral, "Choose a creature you control or reveal a creature card from your hand?", null, "Choose controlled", "Reveal from hand", source, game);
        } else if (hasPermanent) {
            usePermanent = true;
        } else if (hasHand) {
            usePermanent = false;
        } else {
            this.paid = false;
            return this.paid;
        }
        if (usePermanent) {
            TargetControlledCreaturePermanent target = new TargetControlledCreaturePermanent();
            target.withNotTarget(true);
            player.choose(Outcome.Neutral, (Target)target, source, game);
            Permanent permanent = game.getPermanent(target.getFirstTarget());
            if (permanent == null) {
                this.paid = false;
                return this.paid;
            }
            game.informPlayers(player.getLogName() + " chooses " + permanent.getLogName() + " on the battlefield");
            source.getEffects().setValue("monstrousEmergenceCost", (Object)permanent);
            this.paid = true;
            return true;
        }
        TargetCardInHand target = new TargetCardInHand((FilterCard)StaticFilters.FILTER_CARD_CREATURE);
        player.choose(Outcome.Neutral, player.getHand(), (TargetCard)target, source, game);
        Card card = game.getCard(target.getFirstTarget());
        if (card == null) {
            this.paid = false;
            return this.paid;
        }
        player.revealCards(source, (Cards)new CardsImpl(card), game);
        game.informPlayers(player.getLogName() + " reveals " + card.getLogName() + " from their hand");
        source.getEffects().setValue("monstrousEmergenceCost", (Object)card);
        this.paid = true;
        return this.paid;
    }
}

