/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.common.ActivateIfConditionActivatedAbility;
import mage.abilities.common.SimpleActivatedAbility;
import mage.abilities.condition.Condition;
import mage.abilities.costs.Cost;
import mage.abilities.costs.common.TapSourceCost;
import mage.abilities.costs.mana.GenericManaCost;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.continuous.BecomesCreatureSourceEffect;
import mage.abilities.effects.common.search.SearchLibraryPutInHandEffect;
import mage.abilities.keyword.IndestructibleAbility;
import mage.abilities.keyword.ToxicAbility;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.cards.m.MonumentToPerfectionCondition;
import mage.cards.m.MonumentToPerfectionValue;
import mage.constants.CardType;
import mage.constants.Duration;
import mage.constants.SubType;
import mage.constants.SuperType;
import mage.filter.FilterCard;
import mage.filter.common.FilterLandCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.game.permanent.token.Token;
import mage.game.permanent.token.custom.CreatureToken;
import mage.target.common.TargetCardInLibrary;

public final class MonumentToPerfection
extends CardImpl {
    private static final FilterCard filter = new FilterLandCard("a basic, Sphere, or Locus land card");

    public MonumentToPerfection(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.ARTIFACT}, "{2}");
        SimpleActivatedAbility ability = new SimpleActivatedAbility((Effect)new SearchLibraryPutInHandEffect(new TargetCardInLibrary(filter), true), (Cost)new GenericManaCost(3));
        ability.addCost((Cost)new TapSourceCost());
        this.addAbility((Ability)ability);
        this.addAbility(new ActivateIfConditionActivatedAbility((Effect)new BecomesCreatureSourceEffect((Token)new CreatureToken(9, 9, "9/9 Phyrexian Construct artifact creature, loses all abilities, and gains indestructible and toxic 9", new SubType[]{SubType.PHYREXIAN, SubType.CONSTRUCT}).withType(CardType.ARTIFACT).withAbility((Ability)IndestructibleAbility.getInstance()).withAbility((Ability)new ToxicAbility(9)), CardType.ARTIFACT, Duration.Custom).andLoseAbilities(true), (Cost)new GenericManaCost(3), (Condition)MonumentToPerfectionCondition.instance).addHint(MonumentToPerfectionValue.getHint()));
    }

    private MonumentToPerfection(MonumentToPerfection card) {
        super((CardImpl)card);
    }

    public MonumentToPerfection copy() {
        return new MonumentToPerfection(this);
    }

    static {
        filter.add(Predicates.or((Predicate[])new Predicate[]{SuperType.BASIC.getPredicate(), SubType.SPHERE.getPredicate(), SubType.LOCUS.getPredicate()}));
    }
}

