/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import java.util.Collection;
import java.util.Set;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.costs.common.PayLifeCost;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;

class MoonlightBargainEffect
extends OneShotEffect {
    MoonlightBargainEffect() {
        super(Outcome.Benefit);
        this.staticText = "Look at the top five cards of your library. For each card, put that card into your graveyard unless you pay 2 life. Then put the rest into your hand";
    }

    private MoonlightBargainEffect(MoonlightBargainEffect effect) {
        super((OneShotEffect)effect);
    }

    public MoonlightBargainEffect copy() {
        return new MoonlightBargainEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        MageObject sourceObject = source.getSourceObject(game);
        if (controller != null && sourceObject != null) {
            Set topFive = controller.getLibrary().getTopCards(game, 5);
            CardsImpl lookAtCards = new CardsImpl();
            lookAtCards.addAllCards((Collection)topFive);
            controller.lookAtCards(sourceObject.getIdName(), (Cards)lookAtCards, game);
            CardsImpl toHand = new CardsImpl();
            for (Card card : topFive) {
                PayLifeCost cost = new PayLifeCost(2);
                if (!cost.canPay(source, source, source.getControllerId(), game)) continue;
                if (controller.chooseUse(this.outcome, "Put " + card.getIdName() + " into your graveyard unless you pay 2 life", sourceObject.getIdName(), "Pay 2 life and put into hand", "Put into your graveyard", source, game)) {
                    if (cost.pay(source, game, source, source.getControllerId(), false)) {
                        toHand.add(card);
                        continue;
                    }
                    controller.moveCards(card, Zone.GRAVEYARD, source, game);
                    continue;
                }
                controller.moveCards(card, Zone.GRAVEYARD, source, game);
            }
            controller.moveCards((Cards)toHand, Zone.HAND, source, game);
            return true;
        }
        return false;
    }
}

