/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import java.util.Collection;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.cards.m.MoorlandRescuerTarget;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.TargetCard;

class MoorlandRescuerEffect
extends OneShotEffect {
    MoorlandRescuerEffect() {
        super(Outcome.Benefit);
        this.staticText = "return any number of other creature cards with total power X or less from your graveyard to the battlefield, where X is {this}'s power. Exile {this}";
    }

    private MoorlandRescuerEffect(MoorlandRescuerEffect effect) {
        super((OneShotEffect)effect);
    }

    public MoorlandRescuerEffect copy() {
        return new MoorlandRescuerEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        Permanent permanent = (Permanent)this.getValue("permanentLeftBattlefield");
        if (player == null || permanent == null) {
            return false;
        }
        MoorlandRescuerTarget target = new MoorlandRescuerTarget(permanent.getPower().getValue(), source, game);
        player.choose(this.outcome, (Cards)player.getGraveyard(), (TargetCard)target, source, game);
        player.moveCards((Cards)new CardsImpl((Collection)target.getTargets()), Zone.BATTLEFIELD, source, game);
        Card sourceCard = source.getSourceCardIfItStillExists(game);
        if (sourceCard != null) {
            game.processAction();
            player.moveCards(sourceCard, Zone.EXILED, source, game);
        }
        return true;
    }
}

