/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.watchers.common.AttackedThisTurnWatcher;

class MoraugFuryOfAkoumBoostEffect
extends ContinuousEffectImpl {
    MoraugFuryOfAkoumBoostEffect() {
        super(Duration.WhileOnBattlefield, Layer.PTChangingEffects_7, SubLayer.ModifyPT_7c, Outcome.BoostCreature);
        this.staticText = "each creature you control gets +1/+0 for each time it has attacked this turn";
    }

    private MoraugFuryOfAkoumBoostEffect(MoraugFuryOfAkoumBoostEffect effect) {
        super((ContinuousEffectImpl)effect);
    }

    public MoraugFuryOfAkoumBoostEffect copy() {
        return new MoraugFuryOfAkoumBoostEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        AttackedThisTurnWatcher watcher = (AttackedThisTurnWatcher)game.getState().getWatcher(AttackedThisTurnWatcher.class);
        if (watcher == null) {
            return false;
        }
        for (Permanent permanent : game.getBattlefield().getAllActivePermanents((FilterPermanent)StaticFilters.FILTER_PERMANENT_CREATURE, source.getControllerId(), game)) {
            permanent.addPower(watcher.getAttackCount(permanent, game));
        }
        return true;
    }
}

