/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetCardInHand;

class MordenkainenDrawEffect
extends OneShotEffect {
    MordenkainenDrawEffect() {
        super(Outcome.DrawCard);
        this.staticText = "Draw two cards, then put a card from your hand on the bottom of your library";
    }

    private MordenkainenDrawEffect(MordenkainenDrawEffect effect) {
        super((OneShotEffect)effect);
    }

    public MordenkainenDrawEffect copy() {
        return new MordenkainenDrawEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Card card;
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        controller.drawCards(2, source, game);
        TargetCardInHand target = new TargetCardInHand();
        if (controller.chooseTarget(Outcome.Discard, (Target)target, source, game) && (card = game.getCard(target.getFirstTarget())) != null) {
            controller.moveCardToLibraryWithInfo(card, source, game, Zone.HAND, false, false);
        }
        return true;
    }
}

