/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import java.util.Collection;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;

class MordenkainenExchangeEffect
extends OneShotEffect {
    MordenkainenExchangeEffect() {
        super(Outcome.Benefit);
        this.staticText = "Exchange your hand and library, then shuffle";
    }

    private MordenkainenExchangeEffect(MordenkainenExchangeEffect effect) {
        super((OneShotEffect)effect);
    }

    public MordenkainenExchangeEffect copy() {
        return new MordenkainenExchangeEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        CardsImpl hand = new CardsImpl((Collection)controller.getHand());
        CardsImpl library = new CardsImpl((Collection)controller.getLibrary().getCardList());
        controller.putCardsOnTopOfLibrary((Cards)hand, game, source, false);
        controller.moveCards((Cards)library, Zone.HAND, source, game);
        controller.shuffleLibrary(source, game);
        return true;
    }
}

