/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.condition.Condition;
import mage.abilities.condition.common.SourceInGraveyardCondition;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.PutOnLibrarySourceEffect;
import mage.constants.Zone;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;

class MossPitSkeletonTriggeredAbility
extends TriggeredAbilityImpl {
    MossPitSkeletonTriggeredAbility() {
        super(Zone.GRAVEYARD, (Effect)new PutOnLibrarySourceEffect(true).setText("put this card on top of your library"), true);
        this.withInterveningIf((Condition)SourceInGraveyardCondition.instance);
        this.setTriggerPhrase("Whenever one or more +1/+1 counters are put on a creature you control, ");
    }

    private MossPitSkeletonTriggeredAbility(MossPitSkeletonTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public MossPitSkeletonTriggeredAbility copy() {
        return new MossPitSkeletonTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.COUNTERS_ADDED;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        if (event.getData().equals(CounterType.P1P1.getName())) {
            Permanent permanent = game.getPermanentOrLKIBattlefield(event.getTargetId());
            if (permanent == null) {
                permanent = game.getPermanentEntering(event.getTargetId());
            }
            return permanent != null && permanent.isCreature(game) && permanent.isControlledBy(this.getControllerId());
        }
        return false;
    }
}

