/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import java.util.UUID;
import mage.MageObject;
import mage.MageObjectReference;
import mage.ObjectColor;
import mage.abilities.Ability;
import mage.abilities.effects.PreventionEffectImpl;
import mage.cards.Card;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.filter.FilterSource;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.SharesColorPredicate;
import mage.game.ExileZone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.target.TargetSource;
import mage.util.CardUtil;

class MournersShieldEffect
extends PreventionEffectImpl {
    private TargetSource target;
    private MageObjectReference mageObjectReference;
    private boolean noneExiled;

    public MournersShieldEffect() {
        super(Duration.EndOfTurn);
        this.noneExiled = false;
        this.staticText = "Prevent all damage that would be dealt this turn by a source of your choice that shares a color with the exiled card.";
    }

    private MournersShieldEffect(MournersShieldEffect effect) {
        super((PreventionEffectImpl)effect);
        this.target = effect.target != null ? effect.target.copy() : null;
        this.mageObjectReference = effect.mageObjectReference;
        this.noneExiled = effect.noneExiled;
    }

    public MournersShieldEffect copy() {
        return new MournersShieldEffect(this);
    }

    public void init(Ability source, Game game) {
        super.init(source, game);
        ObjectColor colorsAmongImprinted = new ObjectColor();
        Permanent sourceObject = game.getPermanent(source.getSourceId());
        ExileZone exileZone = game.getExile().getExileZone(CardUtil.getCardExileZoneId((Game)game, (UUID)source.getSourceId()));
        if (sourceObject == null || sourceObject.getImprinted() == null) {
            this.noneExiled = true;
            return;
        }
        for (UUID imprinted : sourceObject.getImprinted()) {
            Card card;
            if (imprinted == null || !exileZone.contains((Object)imprinted) || (card = game.getCard(imprinted)) == null) continue;
            colorsAmongImprinted = colorsAmongImprinted.union(card.getColor(game));
        }
        FilterSource filterSource = new FilterSource("a source of your choice that shares a color with the exiled card");
        filterSource.add((Predicate)new SharesColorPredicate(colorsAmongImprinted));
        this.target = new TargetSource(filterSource);
        this.target.choose(Outcome.PreventDamage, source.getControllerId(), source.getSourceId(), source, game);
        this.mageObjectReference = this.target.getFirstTarget() != null ? new MageObjectReference(this.target.getFirstTarget(), game) : null;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        if (this.noneExiled || this.mageObjectReference == null) {
            return false;
        }
        if (super.applies(event, source, game)) {
            MageObject mageObject = game.getObject(event.getSourceId());
            return this.mageObjectReference.refersTo(mageObject, game);
        }
        return false;
    }
}

