/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import mage.abilities.Ability;
import mage.abilities.costs.common.DiscardTargetCost;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.cards.Card;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.common.FilterLandCard;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetCardInHand;

class MoxDiamondReplacementEffect
extends ReplacementEffectImpl {
    MoxDiamondReplacementEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Exile);
        this.staticText = "If {this} would enter, you may discard a land card instead. If you do, put {this} onto the battlefield. If you don't, put it into its owner's graveyard";
    }

    private MoxDiamondReplacementEffect(MoxDiamondReplacementEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public MoxDiamondReplacementEffect copy() {
        return new MoxDiamondReplacementEffect(this);
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        Player player = game.getPlayer(source.getControllerId());
        if (player != null) {
            TargetCardInHand target = new TargetCardInHand((FilterCard)new FilterLandCard());
            DiscardTargetCost cost = new DiscardTargetCost(target);
            if (cost.canPay(source, source, source.getControllerId(), game) && player.chooseUse(this.outcome, "Discard land? (Otherwise Mox Diamond goes to graveyard)", source, game) && player.chooseTarget(Outcome.Discard, (Target)target, source, game)) {
                player.discard(game.getCard(target.getFirstTarget()), false, source, game);
                return false;
            }
            Permanent permanent = game.getPermanentEntering(event.getTargetId());
            if (permanent != null) {
                player.moveCards((Card)permanent, Zone.GRAVEYARD, source, game);
            }
            return true;
        }
        return false;
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ENTERS_THE_BATTLEFIELD;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        return source.getSourceId().equals(event.getTargetId());
    }
}

