/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import mage.abilities.Ability;
import mage.abilities.costs.mana.ManaCostsImpl;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.PreventCombatDamageBySourceEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class MtendaLionEffect
extends OneShotEffect {
    MtendaLionEffect() {
        super(Outcome.Benefit);
        this.staticText = "defending player may pay {U}. If that player does, prevent all combat damage that would be dealt by {this} this turn.";
    }

    private MtendaLionEffect(MtendaLionEffect effect) {
        super((OneShotEffect)effect);
    }

    public MtendaLionEffect copy() {
        return new MtendaLionEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(game.getCombat().getDefendingPlayerId(source.getSourceId(), game));
        if (player == null) {
            return false;
        }
        ManaCostsImpl cost = new ManaCostsImpl("{U}");
        if (!player.chooseUse(this.outcome, "Pay {U} to prevent damage?", source, game) || !cost.pay(source, game, source, player.getId(), false)) {
            return false;
        }
        game.addEffect((ContinuousEffect)new PreventCombatDamageBySourceEffect(Duration.EndOfTurn), source);
        return true;
    }
}

