/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import mage.abilities.Ability;
import mage.abilities.costs.mana.ManaCost;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.keyword.FlyingAbility;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledCreaturePermanent;
import mage.filter.common.FilterControlledPermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.filter.predicate.mageobject.AbilityPredicate;
import mage.filter.predicate.permanent.TappedPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetControlledPermanent;
import mage.util.ManaUtil;

class MudslideEffect
extends OneShotEffect {
    private static final FilterControlledCreaturePermanent filter = new FilterControlledCreaturePermanent("tapped creature without flying");

    MudslideEffect() {
        super(Outcome.Benefit);
        this.staticText = "that player may choose any number of tapped creatures without flying they control and pay {2} for each creature chosen this way. If the player does, untap those creatures.";
    }

    private MudslideEffect(MudslideEffect effect) {
        super((OneShotEffect)effect);
    }

    public MudslideEffect copy() {
        return new MudslideEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        Permanent sourcePermanent = game.getPermanent(source.getSourceId());
        if (player != null && sourcePermanent != null) {
            int countBattlefield = game.getBattlefield().getAllActivePermanents((FilterPermanent)filter, game.getActivePlayerId(), game).size();
            while (player.canRespond() && countBattlefield > 0 && player.chooseUse(Outcome.Benefit, "Pay {2} and untap a tapped creature without flying under your control?", source, game)) {
                TargetControlledPermanent tappedCreatureTarget = new TargetControlledPermanent((FilterControlledPermanent)filter);
                tappedCreatureTarget.withNotTarget(true);
                if (!player.choose(Outcome.Untap, (Target)tappedCreatureTarget, source, game)) break;
                ManaCost cost = ManaUtil.createManaCost((int)2, (boolean)false);
                Permanent tappedCreature = game.getPermanent(tappedCreatureTarget.getFirstTarget());
                if (tappedCreature == null || !cost.pay(source, game, source, player.getId(), false)) break;
                tappedCreature.untap(game);
                countBattlefield = game.getBattlefield().getAllActivePermanents((FilterPermanent)filter, game.getActivePlayerId(), game).size();
            }
            return true;
        }
        return false;
    }

    static {
        filter.add(Predicates.not((Predicate)new AbilityPredicate(FlyingAbility.class)));
        filter.add((Predicate)TappedPredicate.TAPPED);
    }
}

