/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class MultanisDecreeDestroyEffect
extends OneShotEffect {
    public MultanisDecreeDestroyEffect() {
        super(Outcome.DestroyPermanent);
        this.staticText = "Destroy all enchantments. You gain 2 life for each enchantment destroyed this way";
    }

    private MultanisDecreeDestroyEffect(MultanisDecreeDestroyEffect effect) {
        super((OneShotEffect)effect);
    }

    public MultanisDecreeDestroyEffect copy() {
        return new MultanisDecreeDestroyEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        int enchantmentsDestoyed = 0;
        for (Permanent permanent : game.getBattlefield().getActivePermanents((FilterPermanent)StaticFilters.FILTER_PERMANENT_ENCHANTMENT, source.getControllerId(), source, game)) {
            if (!permanent.destroy(source, game, false)) continue;
            ++enchantmentsDestoyed;
        }
        if (enchantmentsDestoyed > 0 && controller != null) {
            controller.gainLife(enchantmentsDestoyed * 2, game, source);
        }
        return false;
    }
}

