/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import mage.constants.WatcherScope;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.stack.Spell;
import mage.watchers.Watcher;

class MultanisPresenceWatcher
extends Watcher {
    private final Map<UUID, List<UUID>> spellsCast = new HashMap<UUID, List<UUID>>();

    public MultanisPresenceWatcher() {
        super(WatcherScope.GAME);
    }

    public void watch(GameEvent event, Game game) {
        Spell spell;
        if (GameEvent.EventType.SPELL_CAST == event.getType() && (spell = game.getSpellOrLKIStack(event.getTargetId())) != null) {
            List<UUID> spellIds = !this.spellsCast.containsKey(spell.getControllerId()) ? new ArrayList<UUID>() : this.spellsCast.get(spell.getControllerId());
            spellIds.add(spell.getId());
            this.spellsCast.put(spell.getControllerId(), spellIds);
        }
    }

    public void reset() {
        super.reset();
        this.spellsCast.clear();
    }

    public List<UUID> getSpellsCastThisTurn(UUID playerId) {
        return this.spellsCast.get(playerId);
    }
}

