/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class MutalithVortexBeastEffect
extends OneShotEffect {
    MutalithVortexBeastEffect() {
        super(Outcome.Benefit);
        this.staticText = "flip a coin for each opponent you have. For each flip you win, draw a card. For each flip you lose, {this} deals 3 damage to that player";
    }

    private MutalithVortexBeastEffect(MutalithVortexBeastEffect effect) {
        super((OneShotEffect)effect);
    }

    public MutalithVortexBeastEffect copy() {
        return new MutalithVortexBeastEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        for (UUID opponentId : game.getOpponents(source.getControllerId())) {
            if (player.flipCoin(source, game, true)) {
                player.drawCards(1, source, game);
                continue;
            }
            Player opponent = game.getPlayer(opponentId);
            if (opponent == null) continue;
            opponent.damage(3, source, game);
        }
        return true;
    }
}

