/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.cards.m.MutatedCultistSpellsCostReductionEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class MutatedCultistEffect
extends OneShotEffect {
    MutatedCultistEffect() {
        super(Outcome.BoostCreature);
        this.staticText = "remove all counters from up to one target permanent or opponent. The next spell you cast this turn costs {1} less to cast for each counter removed this way.";
    }

    private MutatedCultistEffect(MutatedCultistEffect effect) {
        super((OneShotEffect)effect);
    }

    public MutatedCultistEffect copy() {
        return new MutatedCultistEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent targetPermanent;
        int countersRemoved = 0;
        UUID targetId = source.getTargets().getFirstTarget();
        Player targetedPlayer = game.getPlayer(targetId);
        if (targetedPlayer != null) {
            countersRemoved = targetedPlayer.loseAllCounters(source, game);
        }
        if ((targetPermanent = game.getPermanent(targetId)) != null) {
            countersRemoved = targetPermanent.removeAllCounters(source, game);
        }
        if (countersRemoved > 0) {
            game.informPlayers("Removed " + countersRemoved);
            game.addEffect((ContinuousEffect)new MutatedCultistSpellsCostReductionEffect(countersRemoved).setDuration(Duration.OneUse), source);
            return true;
        }
        return false;
    }
}

