/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import java.util.Objects;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;

class MuxusGoblinGrandeeEffect
extends OneShotEffect {
    MuxusGoblinGrandeeEffect() {
        super(Outcome.Benefit);
        this.staticText = "reveal the top six cards of your library. Put all Goblin creature cards with mana value 5 or less from among them onto the battlefield and the rest on the bottom of your library in a random order.";
    }

    private MuxusGoblinGrandeeEffect(MuxusGoblinGrandeeEffect effect) {
        super((OneShotEffect)effect);
    }

    public MuxusGoblinGrandeeEffect copy() {
        return new MuxusGoblinGrandeeEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        CardsImpl cards = new CardsImpl(player.getLibrary().getTopCards(game, 6));
        player.revealCards(source, (Cards)cards, game);
        CardsImpl toBattlfield = new CardsImpl();
        CardsImpl toBottom = new CardsImpl();
        cards.getCards(game).stream().filter(Objects::nonNull).forEach(arg_0 -> MuxusGoblinGrandeeEffect.lambda$apply$0(game, (Cards)toBattlfield, (Cards)toBottom, arg_0));
        player.moveCards((Cards)toBattlfield, Zone.BATTLEFIELD, source, game);
        toBattlfield.stream().filter(uuid -> game.getState().getZone(uuid) == Zone.LIBRARY).forEach(arg_0 -> ((Cards)toBottom).add(arg_0));
        player.putCardsOnBottomOfLibrary((Cards)toBottom, game, source, false);
        return true;
    }

    private static /* synthetic */ void lambda$apply$0(Game game, Cards toBattlfield, Cards toBottom, Card card) {
        if (card.isCreature(game) && card.hasSubtype(SubType.GOBLIN, game) && card.getManaValue() <= 5) {
            toBattlfield.add(card);
        } else {
            toBottom.add(card);
        }
    }
}

