/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import mage.abilities.Ability;
import mage.abilities.dynamicvalue.common.GreatestAmongPermanentsValue;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.common.FilterArtifactCard;
import mage.game.Game;
import mage.players.Player;
import mage.target.TargetCard;

class MuzzioVisionaryArchitectEffect
extends OneShotEffect {
    MuzzioVisionaryArchitectEffect() {
        super(Outcome.Benefit);
        this.staticText = "look at the top X cards of your library, where X is the greatest mana value among artifacts you control. You may put an artifact card from among them onto the battlefield. Put the rest on the bottom of your library in any order";
    }

    private MuzzioVisionaryArchitectEffect(MuzzioVisionaryArchitectEffect effect) {
        super((OneShotEffect)effect);
    }

    public MuzzioVisionaryArchitectEffect copy() {
        return new MuzzioVisionaryArchitectEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Card card;
        TargetCard target;
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        int amount = GreatestAmongPermanentsValue.MANAVALUE_CONTROLLED_ARTIFACTS.calculate(game, source, (Effect)this);
        CardsImpl cards = new CardsImpl(controller.getLibrary().getTopCards(game, amount));
        controller.lookAtCards(source, null, (Cards)cards, game);
        if (!cards.isEmpty() && (target = new TargetCard(0, 1, Zone.LIBRARY, (FilterCard)new FilterArtifactCard("artifact card to put onto the battlefield"))).canChoose(controller.getId(), source, game) && controller.choose(Outcome.Benefit, (Cards)cards, target, source, game) && (card = cards.get(target.getFirstTarget(), game)) != null) {
            controller.revealCards(source, (Cards)new CardsImpl(card), game);
            cards.remove(card);
            controller.moveCards(card, Zone.BATTLEFIELD, source, game);
        }
        controller.putCardsOnBottomOfLibrary((Cards)cards, game, source, true);
        return true;
    }
}

