/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.common.FilterCreatureCard;
import mage.game.Game;
import mage.players.Player;
import mage.watchers.common.CardsPutIntoGraveyardWatcher;

class MyojinOfGrimBetrayalEffect
extends OneShotEffect {
    private final FilterCreatureCard filter;

    MyojinOfGrimBetrayalEffect(FilterCreatureCard filter) {
        super(Outcome.PutCardInPlay);
        this.filter = filter;
        this.staticText = "Put onto the battlefield under your control all creature cards in all graveyards that were put there from anywhere this turn";
    }

    private MyojinOfGrimBetrayalEffect(MyojinOfGrimBetrayalEffect effect) {
        super((OneShotEffect)effect);
        this.filter = effect.filter;
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        CardsPutIntoGraveyardWatcher watcher = (CardsPutIntoGraveyardWatcher)game.getState().getWatcher(CardsPutIntoGraveyardWatcher.class);
        if (controller == null || watcher == null) {
            return false;
        }
        CardsImpl cards = new CardsImpl(watcher.getCardsPutIntoGraveyardFromAnywhere(game));
        cards.removeIf(uuid -> !game.getCard(uuid).isCreature(game));
        return controller.moveCards((Cards)cards, Zone.BATTLEFIELD, source, game);
    }

    public MyojinOfGrimBetrayalEffect copy() {
        return new MyojinOfGrimBetrayalEffect(this);
    }
}

