/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import java.util.Collection;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.CreateTokenCopyTargetEffect;
import mage.cards.Card;
import mage.constants.CardType;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.permanent.PermanentCard;
import mage.players.Player;
import mage.util.CardUtil;

class MyrkulLordOfBonesEffect
extends OneShotEffect {
    MyrkulLordOfBonesEffect() {
        super(Outcome.Benefit);
        this.staticText = "exile it. If you do, create a token that's a copy of that card, except it's an enchantment and loses all other card types";
    }

    private MyrkulLordOfBonesEffect(MyrkulLordOfBonesEffect effect) {
        super((OneShotEffect)effect);
    }

    public MyrkulLordOfBonesEffect copy() {
        return new MyrkulLordOfBonesEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        Card card = game.getCard(this.getTargetPointer().getFirst(game, source));
        if (player == null || card == null) {
            return false;
        }
        player.moveCards(card, Zone.EXILED, source, game);
        return new CreateTokenCopyTargetEffect().setSavedPermanent((Permanent)new PermanentCard(CardUtil.getDefaultCardSideForBattlefield((Game)game, (Card)card), source.getControllerId(), game)).setPermanentModifier(token -> {
            token.removeAllCardTypes();
            token.addCardType(new CardType[]{CardType.ENCHANTMENT});
            token.getSubtype().retainAll((Collection)SubType.getEnchantmentTypes());
        }).apply(game, source);
    }
}

