/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import java.util.Collection;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.common.delayed.OnLeaveReturnExiledAbility;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.ExileZone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.util.CardUtil;

class MysteriousLimousineEffect
extends OneShotEffect {
    MysteriousLimousineEffect() {
        super(Outcome.Exile);
        this.staticText = "exile up to one other target creature until {this} leaves the battlefield. If a creature is put into exile this way, return each other card exiled with {this} to the battlefield under its owner's control";
    }

    private MysteriousLimousineEffect(MysteriousLimousineEffect effect) {
        super((OneShotEffect)effect);
    }

    public MysteriousLimousineEffect copy() {
        return new MysteriousLimousineEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        Permanent permanent = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (player == null || permanent == null || source.getSourcePermanentIfItStillExists(game) == null) {
            return false;
        }
        UUID exileId = CardUtil.getExileZoneId((Game)game, (Ability)source);
        CardsImpl cards = new CardsImpl();
        ExileZone exileZone = game.getExile().getExileZone(exileId);
        if (exileZone != null) {
            cards.addAll((Collection)exileZone);
        }
        player.moveCardsToExile((Card)permanent, source, game, true, exileId, CardUtil.getSourceName((Game)game, (Ability)source));
        if (!cards.isEmpty()) {
            player.moveCards(cards.getCards(game), Zone.BATTLEFIELD, source, game, false, false, true, null);
        }
        game.addDelayedTriggeredAbility((DelayedTriggeredAbility)new OnLeaveReturnExiledAbility(), source);
        return true;
    }
}

