/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import java.util.Collection;
import mage.ApprovingObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;
import mage.target.targetpointer.EachTargetPointer;
import mage.target.targetpointer.TargetPointer;

class MysteriousStrangerEffect
extends OneShotEffect {
    MysteriousStrangerEffect() {
        super(Outcome.Benefit);
        this.staticText = "for each graveyard with an instant or sorcery card in it, exile target instant or sorcery card from that graveyard. If two or more cards are exiled this way, choose one of them at random and copy it. You may cast the copy without paying its mana cost";
        this.setTargetPointer((TargetPointer)new EachTargetPointer());
    }

    private MysteriousStrangerEffect(MysteriousStrangerEffect effect) {
        super((OneShotEffect)effect);
    }

    public MysteriousStrangerEffect copy() {
        return new MysteriousStrangerEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        CardsImpl cards = new CardsImpl((Collection)this.getTargetPointer().getTargets(game, source));
        cards.retainZone(Zone.GRAVEYARD, game);
        if (player == null || cards.isEmpty()) {
            return false;
        }
        player.moveCards((Cards)cards, Zone.EXILED, source, game);
        cards.retainZone(Zone.EXILED, game);
        if (cards.size() < 2) {
            return true;
        }
        Card card = cards.getRandom(game);
        if (card == null) {
            return true;
        }
        Card copiedCard = game.copyCard(card, source, source.getControllerId());
        if (!player.chooseUse(Outcome.PlayForFree, "Cast a copy of " + card.getLogName() + " without paying its mana cost?", source, game)) {
            return true;
        }
        game.getState().setValue("PlayFromNotOwnHandZone" + copiedCard.getId(), (Object)Boolean.TRUE);
        player.cast(player.chooseAbilityForCast(copiedCard, game, true), game, true, new ApprovingObject(source, game));
        game.getState().setValue("PlayFromNotOwnHandZone" + copiedCard.getId(), null);
        return true;
    }
}

