/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.cards.m.MysticReflectionWatcher;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.EntersTheBattlefieldEvent;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;

class MysticReflectionReplacementEffect
extends ReplacementEffectImpl {
    private final int enteredThisTurn;
    private final String identifier;

    MysticReflectionReplacementEffect(int enteredThisTurn, String identifier) {
        super(Duration.EndOfTurn, Outcome.Copy, false);
        this.enteredThisTurn = enteredThisTurn;
        this.identifier = identifier;
        this.staticText = "The next time one or more creatures or planeswalkers enter the battlefield this turn, they enter as copies of {this}";
    }

    private MysticReflectionReplacementEffect(MysticReflectionReplacementEffect effect) {
        super((ReplacementEffectImpl)effect);
        this.enteredThisTurn = effect.enteredThisTurn;
        this.identifier = effect.identifier;
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ENTERS_THE_BATTLEFIELD;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        MysticReflectionWatcher watcher = (MysticReflectionWatcher)game.getState().getWatcher(MysticReflectionWatcher.class);
        if (watcher != null && watcher.getEnteredThisTurn() > this.enteredThisTurn) {
            this.discard();
            return false;
        }
        Permanent permanentEnteringTheBattlefield = ((EntersTheBattlefieldEvent)event).getTarget();
        Permanent targetedPermanent = (Permanent)game.getState().getValue("MysticReflection" + this.identifier);
        return permanentEnteringTheBattlefield != null && targetedPermanent != null && (permanentEnteringTheBattlefield.isCreature(game) || permanentEnteringTheBattlefield.isPlaneswalker(game));
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        Permanent targetedPermanent = (Permanent)game.getState().getValue("MysticReflection" + this.identifier);
        if (targetedPermanent != null) {
            game.copyPermanent(targetedPermanent, event.getTargetId(), source, null);
        }
        return false;
    }

    public MysticReflectionReplacementEffect copy() {
        return new MysticReflectionReplacementEffect(this);
    }
}

