/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import java.util.Objects;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.cards.m.MysticRemoraEffect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.stack.Spell;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class MysticRemoraTriggeredAbility
extends TriggeredAbilityImpl {
    public MysticRemoraTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new MysticRemoraEffect(), false);
    }

    private MysticRemoraTriggeredAbility(MysticRemoraTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public MysticRemoraTriggeredAbility copy() {
        return new MysticRemoraTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.SPELL_CAST;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Spell spell;
        if (game.getOpponents(this.controllerId).contains(event.getPlayerId()) && event.getType() == GameEvent.EventType.SPELL_CAST && (spell = game.getStack().getSpell(event.getTargetId())) != null && !spell.isCreature(game)) {
            Player player;
            Player controller = game.getPlayer(game.getControllerId(this.controllerId));
            if (!Objects.equals(controller, player = game.getPlayer(spell.getControllerId()))) {
                ((Effect)this.getEffects().get(0)).setTargetPointer((TargetPointer)new FixedTarget(event.getPlayerId()));
            }
            return true;
        }
        return false;
    }

    public String getRule() {
        return "Whenever an opponent casts a noncreature spell, you may draw a card unless that player pays {4}.";
    }
}

