/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.permanent.ControllerIdPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetPermanent;

class NeganTheColdBloodedEffect
extends OneShotEffect {
    NeganTheColdBloodedEffect() {
        super(Outcome.Benefit);
        this.staticText = "you and target opponent each secretly choose a creature that player controls. Then those choices are revealed, and that player sacrifices those creatures";
    }

    private NeganTheColdBloodedEffect(NeganTheColdBloodedEffect effect) {
        super((OneShotEffect)effect);
    }

    public NeganTheColdBloodedEffect copy() {
        return new NeganTheColdBloodedEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Player opponent = game.getPlayer(source.getFirstTarget());
        if (controller == null || opponent == null) {
            return false;
        }
        FilterCreaturePermanent filter = new FilterCreaturePermanent("creature controlled by " + opponent.getName());
        filter.add((Predicate)new ControllerIdPredicate(opponent.getId()));
        TargetPermanent target = new TargetPermanent((FilterPermanent)filter);
        target.withNotTarget(true);
        if (!target.canChoose(source.getControllerId(), source, game)) {
            return false;
        }
        LinkedHashSet<UUID> choices = new LinkedHashSet<UUID>();
        controller.choose(Outcome.DestroyPermanent, (Target)target, source, game);
        UUID controllerChoice = target.getFirstTarget();
        choices.add(controllerChoice);
        target.clearChosen();
        opponent.choose(Outcome.DestroyPermanent, (Target)target, source, game);
        UUID opponentChoice = target.getFirstTarget();
        choices.add(opponentChoice);
        for (UUID creatureId : choices) {
            Permanent permanent = game.getPermanent(creatureId);
            if (permanent == null) continue;
            if (Objects.equals(controllerChoice, creatureId)) {
                game.informPlayers(controller.getLogName() + " chose " + permanent.getIdName());
            }
            if (Objects.equals(opponentChoice, creatureId)) {
                game.informPlayers(opponent.getLogName() + " chose " + permanent.getIdName());
            }
            permanent.sacrifice(source, game);
        }
        return true;
    }
}

