/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.constants.CardType;
import mage.constants.DependencyType;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.game.Game;
import mage.game.permanent.Permanent;

class PermanentsAreArtifactsEffect
extends ContinuousEffectImpl {
    PermanentsAreArtifactsEffect() {
        super(Duration.WhileOnBattlefield, Layer.TypeChangingEffects_4, SubLayer.NA, Outcome.Neutral);
        this.staticText = "All permanents are artifacts in addition to their other types";
        this.dependencyTypes.add(DependencyType.ArtifactAddingRemoving);
    }

    public boolean apply(Game game, Ability source) {
        for (Permanent perm : game.getBattlefield().getActivePermanents(source.getControllerId(), game)) {
            perm.addCardType(game, new CardType[]{CardType.ARTIFACT});
        }
        return true;
    }

    public PermanentsAreArtifactsEffect copy() {
        return new PermanentsAreArtifactsEffect(this);
    }

    private PermanentsAreArtifactsEffect(PermanentsAreArtifactsEffect effect) {
        super((ContinuousEffectImpl)effect);
    }
}

