/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.players.Player;

class RemoveCounterMaintenanceHangarEffect
extends OneShotEffect {
    RemoveCounterMaintenanceHangarEffect() {
        super(Outcome.Detriment);
        this.staticText = "remove an additional repair counter from each card in your graveyard";
    }

    private RemoveCounterMaintenanceHangarEffect(RemoveCounterMaintenanceHangarEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            for (Card card : controller.getGraveyard().getCards(game)) {
                if (card.getCounters(game).getCount(CounterType.REPAIR) <= 0) continue;
                card.removeCounters(CounterType.REPAIR.getName(), 1, source, game);
            }
            return true;
        }
        return false;
    }

    public RemoveCounterMaintenanceHangarEffect copy() {
        return new RemoveCounterMaintenanceHangarEffect(this);
    }
}

