/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import mage.abilities.Ability;
import mage.abilities.costs.Cost;
import mage.abilities.costs.VariableCostImpl;
import mage.abilities.costs.VariableCostType;
import mage.abilities.costs.common.TapTargetCost;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledArtifactPermanent;
import mage.filter.common.FilterControlledPermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.permanent.TappedPredicate;
import mage.game.Game;
import mage.target.common.TargetControlledPermanent;

class TapXTargetCost
extends VariableCostImpl {
    static final FilterControlledArtifactPermanent filter = new FilterControlledArtifactPermanent("untapped artifacts you control");

    public TapXTargetCost() {
        super(VariableCostType.NORMAL, "controlled untapped artifacts you would like to tap");
        this.text = "Tap X untapped artifacts you control";
    }

    private TapXTargetCost(TapXTargetCost cost) {
        super((VariableCostImpl)cost);
    }

    public TapXTargetCost copy() {
        return new TapXTargetCost(this);
    }

    public int getMaxValue(Ability source, Game game) {
        return game.getBattlefield().count((FilterPermanent)filter, source.getControllerId(), source, game);
    }

    public Cost getFixedCostsFromAnnouncedValue(int xValue) {
        TargetControlledPermanent target = new TargetControlledPermanent(xValue, xValue, (FilterControlledPermanent)filter, true);
        return new TapTargetCost(target);
    }

    static {
        filter.add((Predicate)TappedPredicate.UNTAPPED);
    }
}

