/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.n;

import mage.abilities.Ability;
import mage.abilities.condition.Condition;
import mage.constants.ComparisonType;
import mage.game.Game;
import mage.players.Player;

class CardsInTargetOpponentHandCondition
implements Condition {
    private Condition condition;
    private ComparisonType type;
    private int count;

    public CardsInTargetOpponentHandCondition() {
        this(ComparisonType.EQUAL_TO, 0);
    }

    public CardsInTargetOpponentHandCondition(ComparisonType type, int count) {
        this.type = type;
        this.count = count;
    }

    public CardsInTargetOpponentHandCondition(ComparisonType type, int count, Condition conditionToDecorate) {
        this(type, count);
        this.condition = conditionToDecorate;
    }

    public boolean apply(Game game, Ability source) {
        boolean conditionApplies = false;
        Player opponent = game.getPlayer(source.getFirstTarget());
        if (opponent == null) {
            return false;
        }
        conditionApplies = ComparisonType.compare((int)opponent.getHand().size(), (ComparisonType)this.type, (int)this.count);
        if (this.condition != null) {
            conditionApplies = conditionApplies && this.condition.apply(game, source);
        }
        return conditionApplies;
    }
}

