/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.n;

import java.util.UUID;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.choices.Choice;
import mage.choices.ChoiceCreatureType;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.constants.SubType;
import mage.game.Game;
import mage.players.Player;

class ChangeCreatureTypeTargetEffect
extends ContinuousEffectImpl {
    private SubType fromSubType;
    private final SubType toSubType;

    public ChangeCreatureTypeTargetEffect(SubType fromSubType, SubType toSubType, Duration duration) {
        super(duration, Layer.TextChangingEffects_3, SubLayer.NA, Outcome.Benefit);
        this.fromSubType = fromSubType;
        this.toSubType = toSubType;
        this.staticText = "Change the text of that creature by replacing all instances of one creature type with Vampire";
    }

    private ChangeCreatureTypeTargetEffect(ChangeCreatureTypeTargetEffect effect) {
        super((ContinuousEffectImpl)effect);
        this.fromSubType = effect.fromSubType;
        this.toSubType = effect.toSubType;
    }

    public void init(Ability source, Game game) {
        super.init(source, game);
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return;
        }
        if (this.fromSubType == null) {
            ChoiceCreatureType typeChoice = new ChoiceCreatureType(game, source);
            typeChoice.setMessage("Choose creature type to change to Vampire");
            if (!controller.choose(this.outcome, (Choice)typeChoice, game)) {
                this.discard();
                return;
            }
            this.fromSubType = SubType.byDescription((String)typeChoice.getChoiceKey());
            if (!game.isSimulation()) {
                game.informPlayers(controller.getLogName() + " has chosen the creature type: " + this.fromSubType.toString());
            }
        }
    }

    public boolean apply(Layer layer, SubLayer sublayer, Ability source, Game game) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        if (this.fromSubType == null) {
            throw new UnsupportedOperationException("No subtype to change set");
        }
        boolean objectFound = false;
        for (UUID targetId : this.getTargetPointer().getTargets(game, source)) {
            MageObject targetObject = game.getObject(targetId);
            if (targetObject != null) {
                objectFound = true;
                if (targetObject.hasSubtype(this.fromSubType, game)) {
                    targetObject.removeSubType(game, this.fromSubType);
                    if (!targetObject.hasSubtype(this.toSubType, game)) {
                        targetObject.addSubType(game, new SubType[]{this.toSubType});
                    }
                }
            }
            if (objectFound || this.getDuration() != Duration.Custom) continue;
            this.discard();
        }
        return true;
    }

    public boolean apply(Game game, Ability source) {
        return false;
    }

    public boolean hasLayer(Layer layer) {
        return layer == Layer.TypeChangingEffects_4;
    }

    public ChangeCreatureTypeTargetEffect copy() {
        return new ChangeCreatureTypeTargetEffect(this);
    }
}

