/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.n;

import java.util.Iterator;
import java.util.List;
import mage.MageObject;
import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;

class DayEffect
extends ContinuousEffectImpl {
    DayEffect() {
        super(Duration.EndOfTurn, Layer.PTChangingEffects_7, SubLayer.ModifyPT_7c, Outcome.BoostCreature);
        this.staticText = "Creatures target player controls get +1/+1 until end of turn";
    }

    private DayEffect(DayEffect effect) {
        super((ContinuousEffectImpl)effect);
    }

    public DayEffect copy() {
        return new DayEffect(this);
    }

    public void init(Ability source, Game game) {
        super.init(source, game);
        if (this.getAffectedObjectsSet()) {
            List creatures = game.getBattlefield().getAllActivePermanents((FilterPermanent)StaticFilters.FILTER_PERMANENT_CREATURE, source.getFirstTarget(), game);
            for (Permanent creature : creatures) {
                this.affectedObjectList.add(new MageObjectReference((MageObject)creature, game));
            }
        }
    }

    public boolean apply(Game game, Ability source) {
        Iterator it = this.affectedObjectList.iterator();
        while (it.hasNext()) {
            Permanent permanent = ((MageObjectReference)it.next()).getPermanent(game);
            if (permanent != null) {
                permanent.addPower(1);
                permanent.addToughness(1);
                continue;
            }
            it.remove();
        }
        return true;
    }
}

