/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.n;

import mage.abilities.Ability;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.condition.Condition;
import mage.abilities.condition.common.PermanentsOnTheBattlefieldCondition;
import mage.abilities.effects.Effect;
import mage.constants.ComparisonType;
import mage.constants.Zone;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.NamePredicate;
import mage.game.Game;
import mage.game.events.EntersTheBattlefieldEvent;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;

class NameStickerGoblinTriggeredAbility
extends TriggeredAbilityImpl {
    private static final FilterControlledCreaturePermanent filter = new FilterControlledCreaturePermanent();
    private static final Condition condition;

    NameStickerGoblinTriggeredAbility(Effect effect) {
        super(Zone.BATTLEFIELD, effect);
        this.setTriggerPhrase("When this creature enters the battlefield from anywhere other than a graveyard or exile, if it's on the battlefield and you control 9 or fewer creatures named \"Name Sticker\" Goblin, ");
    }

    private NameStickerGoblinTriggeredAbility(NameStickerGoblinTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public NameStickerGoblinTriggeredAbility copy() {
        return new NameStickerGoblinTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ENTERS_THE_BATTLEFIELD;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        EntersTheBattlefieldEvent zEvent = (EntersTheBattlefieldEvent)event;
        if (zEvent == null) {
            return false;
        }
        Permanent permanent = zEvent.getTarget();
        if (permanent == null) {
            return false;
        }
        Zone zone = zEvent.getFromZone();
        return zone != Zone.GRAVEYARD && zone != Zone.EXILED && permanent.getId().equals(this.getSourceId());
    }

    public boolean checkInterveningIfClause(Game game) {
        Permanent permanent = this.getSourcePermanentIfItStillExists(game);
        return permanent != null && condition.apply(game, (Ability)this);
    }

    static {
        filter.add((Predicate)new NamePredicate("\"Name Sticker\" Goblin"));
        condition = new PermanentsOnTheBattlefieldCondition((FilterPermanent)filter, ComparisonType.OR_LESS, 9);
    }
}

