/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.n;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.GainLifeEffect;
import mage.abilities.effects.common.LoseLifeOpponentsEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;

class NarciFableSingerEffect
extends OneShotEffect {
    NarciFableSingerEffect() {
        super(Outcome.Benefit);
        this.staticText = "each opponent loses X life and you gain X life, where X is that Saga's mana value.";
    }

    private NarciFableSingerEffect(NarciFableSingerEffect ability) {
        super((OneShotEffect)ability);
    }

    public NarciFableSingerEffect copy() {
        return new NarciFableSingerEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent saga = this.getTargetPointer().getFirstTargetPermanentOrLKI(game, source);
        if (saga == null) {
            return false;
        }
        int value = saga.getManaValue();
        if (value > 0) {
            new LoseLifeOpponentsEffect(value).apply(game, source);
            new GainLifeEffect(value).apply(game, source);
        }
        return true;
    }
}

