/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.n;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import mage.MageObject;
import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.cards.Card;
import mage.constants.WatcherScope;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.stack.Spell;
import mage.watchers.Watcher;

class NashiMoonSagesScionWatcher
extends Watcher {
    private final Map<MageObjectReference, Set<Set<MageObjectReference>>> morMap = new HashMap<MageObjectReference, Set<Set<MageObjectReference>>>();

    public NashiMoonSagesScionWatcher() {
        super(WatcherScope.GAME);
    }

    public void watch(GameEvent event, Game game) {
        if (event.getType() == GameEvent.EventType.CLEANUP_STEP_POST) {
            this.morMap.entrySet().removeIf(e -> !((MageObjectReference)e.getKey()).zoneCounterIsCurrent(game));
            this.morMap.values().stream().flatMap(Collection::stream).forEach(set -> set.removeIf(mor -> !mor.zoneCounterIsCurrent(game)));
            this.morMap.values().removeIf(Set::isEmpty);
            return;
        }
        if (event.getType() != GameEvent.EventType.SPELL_CAST || event.getApprovingObject() == null) {
            return;
        }
        Spell spell = game.getSpell(event.getTargetId());
        if (spell == null) {
            return;
        }
        this.morMap.getOrDefault(event.getApprovingObject().getApprovingMageObjectReference(), Collections.emptySet()).removeIf(set -> set.stream().anyMatch(mor -> mor.getSourceId().equals(spell.getMainCard().getId()) && mor.getZoneChangeCounter() + 1 == spell.getZoneChangeCounter(game)));
    }

    public void reset() {
        super.reset();
        this.morMap.clear();
    }

    static void addCards(Ability source, Set<Card> cards, Game game) {
        ((NashiMoonSagesScionWatcher)game.getState().getWatcher(NashiMoonSagesScionWatcher.class)).morMap.computeIfAbsent(new MageObjectReference(source), x -> new HashSet()).add(cards.stream().map(card -> new MageObjectReference((MageObject)card, game)).collect(Collectors.toSet()));
    }

    static boolean checkCard(Game game, Ability source, MageObjectReference mor) {
        return ((NashiMoonSagesScionWatcher)game.getState().getWatcher(NashiMoonSagesScionWatcher.class)).morMap.getOrDefault(new MageObjectReference(source), Collections.emptySet()).stream().flatMap(Collection::stream).anyMatch(arg_0 -> ((MageObjectReference)mor).equals(arg_0));
    }
}

