/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.n;

import java.util.UUID;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.cards.n.NayaSoulbeastReplacementEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class NayaSoulbeastCastEffect
extends OneShotEffect {
    NayaSoulbeastCastEffect() {
        super(Outcome.Benefit);
        this.staticText = "each player reveals the top card of their library";
    }

    private NayaSoulbeastCastEffect(NayaSoulbeastCastEffect effect) {
        super((OneShotEffect)effect);
    }

    public NayaSoulbeastCastEffect copy() {
        return new NayaSoulbeastCastEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        MageObject sourceObject = source.getSourceObject(game);
        if (controller != null && sourceObject != null) {
            int cmc = 0;
            for (UUID playerId : game.getState().getPlayersInRange(controller.getId(), game)) {
                Player player = game.getPlayer(playerId);
                if (player == null || !player.getLibrary().hasCards()) continue;
                Card card = player.getLibrary().getFromTop(game);
                cmc += card.getManaValue();
                player.revealCards(sourceObject.getName() + " (" + player.getName() + ')', (Cards)new CardsImpl(card), game);
            }
            for (Effect effect : source.getEffects()) {
                if (!(effect instanceof NayaSoulbeastReplacementEffect)) continue;
                effect.setValue("NayaSoulbeastCounters", (Object)cmc);
            }
            return true;
        }
        return false;
    }
}

