/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.n;

import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;

class NayaSoulbeastReplacementEffect
extends ReplacementEffectImpl {
    NayaSoulbeastReplacementEffect() {
        super(Duration.OneUse, Outcome.BoostCreature);
        this.staticText = "{this} enters with X +1/+1 counters on it, where X is the total mana value of all cards revealed this way";
    }

    private NayaSoulbeastReplacementEffect(NayaSoulbeastReplacementEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ENTERS_THE_BATTLEFIELD;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        return event.getTargetId().equals(source.getSourceId());
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        Object object = this.getValue("NayaSoulbeastCounters");
        Permanent permanent = game.getPermanentEntering(source.getSourceId());
        if (permanent != null && object instanceof Integer) {
            int amount = (Integer)object;
            permanent.addCounters(CounterType.P1P1.createInstance(amount), source.getControllerId(), source, game);
        }
        return false;
    }

    public NayaSoulbeastReplacementEffect copy() {
        return new NayaSoulbeastReplacementEffect(this);
    }
}

