/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.n;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;
import mage.util.CardUtil;

class NebuchadnezzarEffect
extends OneShotEffect {
    NebuchadnezzarEffect() {
        super(Outcome.Detriment);
        this.staticText = "Target opponent reveals X cards at random from their hand. Then that player discards all cards with that name revealed this way";
    }

    private NebuchadnezzarEffect(NebuchadnezzarEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player opponent = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        MageObject sourceObject = game.getObject(source);
        String cardName = (String)game.getState().getValue(source.getSourceId().toString() + "NAMED_CARD");
        if (opponent == null || sourceObject == null || cardName.isEmpty()) {
            return false;
        }
        int costX = (Integer)CardUtil.getSourceCostsTag((Game)game, (Ability)source, (String)"X", (Object)0);
        if (costX <= 0 || opponent.getHand().isEmpty()) {
            return true;
        }
        CardsImpl cards = new CardsImpl();
        while (costX > 0) {
            Card card = opponent.getHand().getRandom(game);
            if (!cards.contains((Object)card.getId())) {
                cards.add(card);
                --costX;
            }
            if (opponent.getHand().size() > cards.size()) continue;
            break;
        }
        opponent.revealCards(sourceObject.getIdName(), (Cards)cards, game);
        cards.removeIf(uuid -> !cardName.equals(game.getCard(uuid).getName()));
        opponent.discard((Cards)cards, false, source, game);
        return true;
    }

    public NebuchadnezzarEffect copy() {
        return new NebuchadnezzarEffect(this);
    }
}

