/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.n;

import java.util.Set;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.FilterCard;
import mage.filter.common.FilterCreatureCard;
import mage.game.ExileZone;
import mage.game.Game;
import mage.game.permanent.token.ZombieToken;
import mage.players.Player;
import mage.util.CardUtil;

class NecromancersConvenantEffect
extends OneShotEffect {
    NecromancersConvenantEffect() {
        super(Outcome.PutCreatureInPlay);
        this.staticText = "exile all creature cards from target player's graveyard, then create a 2/2 black Zombie creature token for each card exiled this way";
    }

    private NecromancersConvenantEffect(NecromancersConvenantEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Player player = game.getPlayer(source.getFirstTarget());
        if (controller == null || player == null) {
            return false;
        }
        Set cards = player.getGraveyard().getCards((FilterCard)new FilterCreatureCard(), game);
        UUID exileId = CardUtil.getCardExileZoneId((Game)game, (Ability)source);
        controller.moveCardsToExile(cards, source, game, true, exileId, "Necromancer's Convenant");
        ExileZone exileZone = game.getState().getExile().getExileZone(exileId);
        if (exileZone != null) {
            int count = exileZone.getCards(game).size();
            return count > 0 && new ZombieToken().putOntoBattlefield(count, game, source, controller.getId());
        }
        return false;
    }

    public NecromancersConvenantEffect copy() {
        return new NecromancersConvenantEffect(this);
    }
}

