/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.n;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.cards.Card;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.ZoneChangeEvent;
import mage.game.permanent.Permanent;
import mage.players.Player;

class NecromancersMagemarkEffect
extends ReplacementEffectImpl {
    NecromancersMagemarkEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Benefit);
        this.staticText = "If a creature you control that's enchanted would die, return it to its owner's hand instead";
    }

    private NecromancersMagemarkEffect(NecromancersMagemarkEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public NecromancersMagemarkEffect copy() {
        return new NecromancersMagemarkEffect(this);
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        Permanent permanent;
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null && (permanent = ((ZoneChangeEvent)event).getTarget()) != null) {
            controller.moveCards((Card)permanent, Zone.HAND, source, game);
            return true;
        }
        return false;
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ZONE_CHANGE;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        Permanent permanent;
        ZoneChangeEvent zEvent = (ZoneChangeEvent)event;
        if (zEvent.isDiesEvent() && (permanent = ((ZoneChangeEvent)event).getTarget()) != null && permanent.isControlledBy(source.getControllerId())) {
            for (UUID attachmentId : permanent.getAttachments()) {
                Permanent attachment = game.getPermanentOrLKIBattlefield(attachmentId);
                if (attachment == null || !attachment.hasSubtype(SubType.AURA, game)) continue;
                return true;
            }
        }
        return false;
    }
}

