/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.n;

import java.util.ArrayList;
import java.util.UUID;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.AddCreatureTypeAdditionEffect;
import mage.cards.Card;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.filter.common.FilterCreatureCard;
import mage.filter.predicate.Predicates;
import mage.filter.predicate.mageobject.CardIdPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetCardInGraveyard;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;
import mage.util.CardUtil;

class NecromanticSelectionEffect
extends OneShotEffect {
    NecromanticSelectionEffect() {
        super(Outcome.DestroyPermanent);
        this.staticText = "Destroy all creatures, then return a creature card put into a graveyard this way to the battlefield under your control. It's a black Zombie in addition to its other colors and types";
    }

    private NecromanticSelectionEffect(NecromanticSelectionEffect effect) {
        super((OneShotEffect)effect);
    }

    public NecromanticSelectionEffect copy() {
        return new NecromanticSelectionEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Card card;
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        CardsImpl cards = new CardsImpl();
        for (Permanent permanent : game.getBattlefield().getActivePermanents((FilterPermanent)StaticFilters.FILTER_PERMANENT_CREATURE, controller.getId(), source, game)) {
            permanent.destroy(source, game, false);
            if (game.getState().getZone(permanent.getId()) != Zone.GRAVEYARD) continue;
            cards.add((Card)permanent);
        }
        game.processAction();
        MageObject sourceObject = game.getObject(source);
        String sourceName = sourceObject != null ? sourceObject.getLogName() : "";
        FilterCreatureCard filter = new FilterCreatureCard("creature card put into a graveyard with " + sourceName);
        ArrayList<CardIdPredicate> cardIdPredicates = new ArrayList<CardIdPredicate>();
        for (UUID cardId : cards) {
            cardIdPredicates.add(new CardIdPredicate(cardId));
        }
        filter.add(Predicates.or(cardIdPredicates));
        TargetCardInGraveyard target = new TargetCardInGraveyard((FilterCard)filter);
        target.withNotTarget(true);
        if (controller.chooseTarget(Outcome.PutCreatureInPlay, (Target)target, source, game) && (card = game.getCard(target.getFirstTarget())) != null) {
            controller.moveCards(card, Zone.BATTLEFIELD, source, game);
            Permanent permanent = CardUtil.getPermanentFromCardPutToBattlefield((Card)card, (Game)game);
            if (permanent != null) {
                AddCreatureTypeAdditionEffect effect = new AddCreatureTypeAdditionEffect(SubType.ZOMBIE, true);
                effect.setText("It's a black Zombie in addition to its other colors and types");
                effect.setTargetPointer((TargetPointer)new FixedTarget(permanent.getId(), game));
                game.addEffect((ContinuousEffect)effect, source);
            }
        }
        return true;
    }
}

