/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.n;

import java.util.Collection;
import java.util.HashSet;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.NamePredicate;
import mage.game.Game;
import mage.game.permanent.token.ZombieToken;
import mage.players.Player;
import mage.target.TargetCard;
import mage.target.common.TargetCardInLibrary;

class NecromentiaEffect
extends OneShotEffect {
    NecromentiaEffect() {
        super(Outcome.Benefit);
        this.staticText = "Search target opponent's graveyard, hand, and library for any number of cards with that name and exile them. That player shuffles, then creates a 2/2 black Zombie creature token for each card exiled from their hand this way";
    }

    private NecromentiaEffect(NecromentiaEffect effect) {
        super((OneShotEffect)effect);
    }

    public NecromentiaEffect copy() {
        return new NecromentiaEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        String cardName = (String)game.getState().getValue(source.getSourceId().toString() + "NAMED_CARD");
        Player controller = game.getPlayer(source.getControllerId());
        if (cardName != null && controller != null) {
            int cardsCount;
            FilterCard filter = new FilterCard("card named " + cardName);
            filter.add((Predicate)new NamePredicate(cardName));
            Player targetPlayer = game.getPlayer(this.getTargetPointer().getFirst(game, source));
            int n = cardsCount = cardName.isEmpty() ? 0 : targetPlayer.getGraveyard().count(filter, game);
            if (cardsCount > 0) {
                filter.setMessage("card named " + cardName + " in the graveyard of " + targetPlayer.getName());
                TargetCard target = new TargetCard(0, cardsCount, Zone.GRAVEYARD, filter);
                if (controller.choose(Outcome.Exile, (Cards)targetPlayer.getGraveyard(), target, source, game)) {
                    controller.moveCards((Cards)new CardsImpl((Collection)target.getTargets()), Zone.EXILED, source, game);
                }
            }
            int numberOfCardsExiledFromHand = 0;
            int n2 = cardsCount = cardName.isEmpty() ? 0 : targetPlayer.getHand().count(filter, game);
            if (cardsCount > 0) {
                filter.setMessage("card named " + cardName + " in the hand of " + targetPlayer.getName());
                TargetCard target = new TargetCard(0, cardsCount, Zone.HAND, filter);
                if (controller.choose(Outcome.Exile, targetPlayer.getHand(), target, source, game)) {
                    numberOfCardsExiledFromHand = target.getTargets().size();
                    controller.moveCards((Cards)new CardsImpl((Collection)target.getTargets()), Zone.EXILED, source, game);
                }
            } else {
                targetPlayer.revealCards(targetPlayer.getName() + "'s Hand", targetPlayer.getHand(), game);
            }
            CardsImpl cardsInLibrary = new CardsImpl();
            cardsInLibrary.addAllCards((Collection)targetPlayer.getLibrary().getCards(game));
            int n3 = cardsCount = cardName.isEmpty() ? 0 : cardsInLibrary.count(filter, game);
            if (cardsCount > 0) {
                filter.setMessage("card named " + cardName + " in the library of " + targetPlayer.getLogName());
                TargetCardInLibrary targetLib = new TargetCardInLibrary(0, cardsCount, filter);
                if (controller.choose(Outcome.Exile, (Cards)cardsInLibrary, (TargetCard)targetLib, source, game)) {
                    controller.moveCards((Cards)new CardsImpl((Collection)targetLib.getTargets()), Zone.EXILED, source, game);
                }
            } else {
                targetPlayer.revealCards(targetPlayer.getName() + "'s Library", (Cards)new CardsImpl(new HashSet(targetPlayer.getLibrary().getCards(game))), game);
            }
            targetPlayer.shuffleLibrary(source, game);
            if (numberOfCardsExiledFromHand > 0) {
                game.processAction();
                ZombieToken zombieToken = new ZombieToken();
                zombieToken.putOntoBattlefield(numberOfCardsExiledFromHand, game, source, targetPlayer.getId());
            }
            return true;
        }
        return false;
    }
}

