/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.n;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.common.DiesAttachedTriggeredAbility;
import mage.abilities.common.SimpleStaticAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.AttachEffect;
import mage.abilities.effects.common.SacrificeSourceEffect;
import mage.abilities.effects.common.continuous.GainAbilityAttachedEffect;
import mage.abilities.keyword.EnchantAbility;
import mage.abilities.triggers.BeginningOfUpkeepTriggeredAbility;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.cards.n.NecroticPlagueAdjuster;
import mage.cards.n.NecroticPlagueEffect;
import mage.constants.AttachmentType;
import mage.constants.CardType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.target.Target;
import mage.target.common.TargetCreaturePermanent;
import mage.target.targetadjustment.TargetAdjuster;

public final class NecroticPlague
extends CardImpl {
    public NecroticPlague(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.ENCHANTMENT}, "{2}{B}{B}");
        this.subtype.add((Object)SubType.AURA);
        TargetCreaturePermanent auraTarget = new TargetCreaturePermanent();
        this.getSpellAbility().addTarget((Target)auraTarget);
        this.getSpellAbility().addEffect((Effect)new AttachEffect(Outcome.Detriment));
        EnchantAbility ability = new EnchantAbility((Target)auraTarget);
        this.addAbility((Ability)ability);
        ability = new BeginningOfUpkeepTriggeredAbility((Effect)new SacrificeSourceEffect());
        GainAbilityAttachedEffect effect = new GainAbilityAttachedEffect((Ability)ability, AttachmentType.AURA, Duration.WhileOnBattlefield);
        effect.setText("Enchanted creature has \"At the beginning of your upkeep, sacrifice this creature.\"");
        this.addAbility((Ability)new SimpleStaticAbility((Effect)effect));
        ability = new DiesAttachedTriggeredAbility((Effect)new NecroticPlagueEffect(), "enchanted creature", false);
        ability.setTargetAdjuster((TargetAdjuster)NecroticPlagueAdjuster.instance);
        this.addAbility((Ability)ability);
    }

    private NecroticPlague(NecroticPlague card) {
        super((CardImpl)card);
    }

    public NecroticPlague copy() {
        return new NecroticPlague(this);
    }
}

