/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.n;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class NecroticPlagueEffect
extends OneShotEffect {
    NecroticPlagueEffect() {
        super(Outcome.PutCardInPlay);
        this.staticText = "its controller chooses target creature one of their opponents controls. Return {this} from its owner's graveyard to the battlefield attached to that creature";
    }

    private NecroticPlagueEffect(NecroticPlagueEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player creatureController;
        Permanent attachedTo = (Permanent)this.getValue("attachedTo");
        if (attachedTo != null && (creatureController = game.getPlayer(attachedTo.getControllerId())) != null) {
            Card sourceEnchantmentCard = game.getCard(source.getSourceId());
            Permanent creature = game.getPermanent(this.getTargetPointer().getFirst(game, source));
            if (sourceEnchantmentCard != null && creature != null) {
                game.getState().setValue("attachTo:" + sourceEnchantmentCard.getId(), (Object)creature);
                creatureController.moveCards(sourceEnchantmentCard, Zone.BATTLEFIELD, source, game);
                return creature.addAttachment(sourceEnchantmentCard.getId(), source, game);
            }
        }
        return false;
    }

    public NecroticPlagueEffect copy() {
        return new NecroticPlagueEffect(this);
    }
}

