/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.n;

import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.players.Player;

class NefariousLichLifeGainReplacementEffect
extends ReplacementEffectImpl {
    NefariousLichLifeGainReplacementEffect() {
        super(Duration.WhileOnBattlefield, Outcome.DrawCard);
        this.staticText = "If you would gain life, draw that many cards instead";
    }

    private NefariousLichLifeGainReplacementEffect(NefariousLichLifeGainReplacementEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public NefariousLichLifeGainReplacementEffect copy() {
        return new NefariousLichLifeGainReplacementEffect(this);
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        Player controller = game.getPlayer(event.getPlayerId());
        if (controller != null) {
            controller.drawCards(event.getAmount(), source, game);
        }
        return true;
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.GAIN_LIFE;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        return event.getPlayerId().equals(source.getControllerId());
    }
}

