/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.n;

import mage.Mana;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.ManaType;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class NehebDreadhordeChampionEffect
extends OneShotEffect {
    NehebDreadhordeChampionEffect() {
        super(Outcome.Benefit);
        this.staticText = "discard any number of cards. If you do, draw that many cards and add that much {R}. Until end of turn, you don't lose this mana as steps and phases end.";
    }

    private NehebDreadhordeChampionEffect(NehebDreadhordeChampionEffect effect) {
        super((OneShotEffect)effect);
    }

    public NehebDreadhordeChampionEffect copy() {
        return new NehebDreadhordeChampionEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        int counter = player.discard(0, Integer.MAX_VALUE, false, source, game).size();
        if (counter < 1) {
            return true;
        }
        player.drawCards(counter, source, game);
        player.getManaPool().addMana(new Mana(ManaType.RED, counter), game, source, true);
        return true;
    }
}

