/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.n;

import java.util.UUID;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class NemesisOfReasonTriggeredAbility
extends TriggeredAbilityImpl {
    NemesisOfReasonTriggeredAbility(Effect effect) {
        super(Zone.BATTLEFIELD, effect);
    }

    private NemesisOfReasonTriggeredAbility(NemesisOfReasonTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public NemesisOfReasonTriggeredAbility copy() {
        return new NemesisOfReasonTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ATTACKER_DECLARED;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        if (event.getSourceId().equals(this.getSourceId())) {
            UUID defenderId = game.getCombat().getDefendingPlayerId(this.getSourceId(), game);
            for (Effect effect : this.getEffects()) {
                effect.setTargetPointer((TargetPointer)new FixedTarget(defenderId));
            }
            return true;
        }
        return false;
    }

    public String getRule() {
        return "Whenever {this} attacks, defending player mills ten cards.";
    }
}

