/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.n;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class NeonatesRushEffect
extends OneShotEffect {
    NeonatesRushEffect() {
        super(Outcome.Benefit);
        this.staticText = "{this} deals 1 damage to target creature and 1 damage to its controller.";
    }

    private NeonatesRushEffect(NeonatesRushEffect effect) {
        super((OneShotEffect)effect);
    }

    public NeonatesRushEffect copy() {
        return new NeonatesRushEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanent(source.getFirstTarget());
        if (permanent == null) {
            return false;
        }
        permanent.damage(1, source.getSourceId(), source, game);
        Player player = game.getPlayer(permanent.getControllerId());
        if (player != null) {
            player.damage(1, source.getSourceId(), source, game);
        }
        return true;
    }
}

