/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.n;

import java.util.Collection;
import java.util.Set;
import mage.abilities.Ability;
import mage.abilities.condition.Condition;
import mage.abilities.decorator.ConditionalAsThoughEffect;
import mage.abilities.dynamicvalue.common.DifferentlyNamedPermanentCount;
import mage.abilities.effects.AsThoughEffect;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.asthought.PlayFromNotOwnHandZoneTargetEffect;
import mage.abilities.hint.Hint;
import mage.cards.n.CommanderAttackedThisTurnCondition;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledPermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.permanent.TokenPredicate;
import mage.game.Game;
import mage.players.Player;
import mage.target.targetpointer.FixedTargets;
import mage.target.targetpointer.TargetPointer;
import mage.util.CardUtil;

class NerivCracklingVanguardEffect
extends OneShotEffect {
    private static final FilterPermanent filter = new FilterControlledPermanent("tokens you control");
    private static final DifferentlyNamedPermanentCount xValue;

    static final Hint getHint() {
        return xValue.getHint();
    }

    NerivCracklingVanguardEffect() {
        super(Outcome.Benefit);
        this.staticText = "exile a number of cards from the top of your library equal to the number of differently named tokens you control. During any turn you attacked with a commander, you may play those cards.";
    }

    private NerivCracklingVanguardEffect(NerivCracklingVanguardEffect effect) {
        super((OneShotEffect)effect);
    }

    public NerivCracklingVanguardEffect copy() {
        return new NerivCracklingVanguardEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        int tokenNameCount = xValue.calculate(game, source, (Effect)this);
        if (controller == null || tokenNameCount == 0) {
            return false;
        }
        Set cards = controller.getLibrary().getTopCards(game, tokenNameCount);
        if (cards.isEmpty()) {
            return false;
        }
        controller.moveCardsToExile(cards, source, game, true, CardUtil.getExileZoneId((Game)game, (Ability)source), CardUtil.getSourceName((Game)game, (Ability)source));
        Ability copiedAbility = source.copy();
        copiedAbility.newId();
        copiedAbility.setControllerId(source.getControllerId());
        PlayFromNotOwnHandZoneTargetEffect playFromExile = new PlayFromNotOwnHandZoneTargetEffect(Zone.EXILED, Duration.EndOfGame);
        playFromExile.setTargetPointer((TargetPointer)new FixedTargets((Collection)cards, game));
        ConditionalAsThoughEffect playOnlyIfAttackedWithCommander = new ConditionalAsThoughEffect((AsThoughEffect)playFromExile, (Condition)new CommanderAttackedThisTurnCondition(copiedAbility));
        playOnlyIfAttackedWithCommander.setTargetPointer((TargetPointer)new FixedTargets((Collection)cards, game));
        game.addEffect((ContinuousEffect)playOnlyIfAttackedWithCommander, copiedAbility);
        return true;
    }

    static {
        filter.add((Predicate)TokenPredicate.TRUE);
        xValue = new DifferentlyNamedPermanentCount(filter);
    }
}

