/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.n;

import java.util.UUID;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.ReturnSourceFromGraveyardToBattlefieldEffect;
import mage.abilities.triggers.BeginningOfUpkeepTriggeredAbility;
import mage.cards.Card;
import mage.constants.TargetController;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;

class NetherShadowTriggerdAbility
extends BeginningOfUpkeepTriggeredAbility {
    public NetherShadowTriggerdAbility() {
        super(Zone.GRAVEYARD, TargetController.YOU, (Effect)new ReturnSourceFromGraveyardToBattlefieldEffect(), true);
    }

    private NetherShadowTriggerdAbility(NetherShadowTriggerdAbility effect) {
        super((BeginningOfUpkeepTriggeredAbility)effect);
    }

    public boolean checkInterveningIfClause(Game game) {
        Player controller = game.getPlayer(this.controllerId);
        if (controller != null) {
            int count = -1;
            for (UUID uuid : controller.getGraveyard()) {
                if (count == -1) {
                    if (!uuid.equals(this.sourceId)) continue;
                    count = 0;
                    continue;
                }
                Card card = game.getCard(uuid);
                if (card == null || !card.isCreature(game)) continue;
                ++count;
            }
            return count >= 3;
        }
        return false;
    }

    public NetherShadowTriggerdAbility copy() {
        return new NetherShadowTriggerdAbility(this);
    }

    public String getRule() {
        return "At the beginning of your upkeep, if {this} is in your graveyard with three or more creature cards above it, you may put {this} onto the battlefield.";
    }
}

